
// kesion.judge 2017-5-31 v1.0
$(function(){
	$('body').append('<div id="textTips" class="d-none"></div>');
	
});

function selectStyle(){

	$('.drag-select-style').on('click',function(e){
		var flag = $(this).attr('data-flag');
		if(flag==0){
			$(this).addClass('drag-selected');
			$(this).find('.option-wrap').show();
			$(this).attr('data-flag','1');
		}else{
			$(this).removeClass('drag-selected');
			$(this).find('.option-wrap').hide();
			$(this).attr('data-flag','0');
		};
		e.stopPropagation();
	});
	$('.drag-select-style').on('click','.option',function(e){
		var value = $(this).attr('option-value');
		var text = $(this).html();
		$(this).parents('.drag-select-style').find('.selected').html(text).attr('option-value',value);
	});
	
	$(document).on('click',function(){
		$('.drag-select-style').removeClass('drag-selected');
		$('.drag-select-style').find('.option-wrap').hide();
		$('.drag-select-style').attr('data-flag','0');
	});
	
};


(function ($) {
	//整数判断
	$.fn.integer = function(parameter){
		var $this = $(this);
		$this.on('keyup',function(){
				var tWidth = $this.outerWidth();
				var tHeight = $this.outerHeight();
				var oLeft = $this.offset().left;
				var oTop = $this.offset().top-tHeight-10;
				var $textTips = $('#textTips');
				var val = $(this).val();
				var result = /^([1-9]\d*|[0]{1,1})$/.test(val)?"yes":"no";
				if(result!='yes'){
					$(this).addClass('text-error');
					$textTips.html('请输入纯数字').show().css({left:oLeft,top:oTop});
					if($textTips.outerWidth()>tWidth){
						var mLeft = oLeft-($textTips.outerWidth()-tWidth)/2;
						$textTips.css({left:mLeft})
					};
					
				}else{
					$(this).removeClass('text-error');
					$textTips.hide();
				};
		});
		
	};

	$.fn.checkbox = function(parameter){
		
		var $this = $(this);
		var name = $this.attr('name');
		$this.hide();
		if($this.is(':checked')==true){
			$this.after('<div class="ks-checkbox-style ks-checked" check-flag="1" check-name="'+name+'"><i></i></div>');
		}else{
			$this.after('<div class="ks-checkbox-style" check-flag="0" check-name="'+name+'"><i></i></div>');
		};
		
		$this.next('.ks-checkbox-style').on('click',function(){
			if($(this).attr('check-flag')=='0'){
				$(this).addClass('ks-checked');
				$(this).prev().attr('checked',true);
				$(this).attr('check-flag','1');
			}else{
				$(this).removeClass('ks-checked');
				$(this).prev().attr('checked',false);
				$(this).attr('check-flag','0');
				
			};
		});
		
		
	};

	$.fn.clickMove = function(parameter){
		
		var $this = $(this);
		var maxValue = parameter.maxValue;
		var Default = parameter.Default;
		var flag = false;
		if(!Default){
			Default = 0;
		};
		if(Default>maxValue){
			Default = maxValue;
		}else if(Default<0){
			Default = 0;
		};
		
		$this.append('<div class="bg-bar"><div class="bg-bared"></div><i class="click-dot"></i></div><div class="move-percent">0</div>')
		var $bar = $this.find('.bg-bar');
		var $bared = $this.find('.bg-bared');
		var $percent = $this.find('.move-percent');
		var $dot = $this.find('.click-dot');
		var barWidth = $this.find('.bg-bar').outerWidth() - $dot.outerWidth();
		var time = barWidth/maxValue;
		var pLeft =  Default*time;
		var pageX;
		
		$dot.css({left:pLeft});
		$bared.width(pLeft);
		$percent.html(Math.ceil(pLeft/time));
		$dot.mousedown(function(e){
			pageX = e.pageX;
			flag = true;
			pLeft = $(this).position().left;
			
		});
		
		$bar.mousedown(function(e){
			pLeft = e.pageX - $bar.offset().left - $dot.outerWidth()/2;
			pLeft = Math.min(Math.max(pLeft,0),barWidth)
			$dot.css({left:pLeft});
			$bared.width(pLeft);
			$percent.html(Math.ceil(pLeft/time));
		});
		
		$(document).mousemove(function(e){
			if(flag==true){
				var result = e.pageX - pageX;
				if(result>0){
					result = Math.min(result+pLeft,barWidth);
				}else{
					result = Math.max(pLeft-(-result),0);
				};

				var percent = Math.ceil(result/time);
				$dot.css({left:result});
				$bared.width(result);
				$percent.html(percent);
			};
			
		});
		$(document).mouseup(function(){
			flag = false;
		});
		
		
		$(document).bind("selectstart",function(){
			if(flag==true){
				return false;
			};
		});
		
		
	};


})(jQuery);


